#ifndef PRISM2_AP_H
#define PRISM2_AP_H

/* AP data structures for STAs */

/* maximum number of frames to buffer per STA */
#define STA_MAX_TX_BUFFER 32

struct sta_buffer_frame {
	struct sta_buffer_frame *next;

	unsigned long rx_time;
	struct hfa384x_tx_frame txdesc;
	struct sk_buff *skb;
};


/* STA flags */
#define WLAN_STA_AUTH BIT(0)
#define WLAN_STA_ASSOC BIT(1)
#define WLAN_STA_PS BIT(2)

#define WLAN_RATE_1M BIT(0)
#define WLAN_RATE_2M BIT(1)
#define WLAN_RATE_5M5 BIT(2)
#define WLAN_RATE_11M BIT(3)
#define WLAN_RATE_COUNT 4

/* Try to increase TX rate after # successfully sent packets */
#define WLAN_RATE_UPDATE_COUNT 50

struct sta_info {
	struct list_head list;
	struct sta_info *hnext; /* next entry in hash table list */
	atomic_t users; /* number of users (do not remove if > 0) */
	struct proc_dir_entry *proc;

	u8 addr[6];
	u16 aid; /* STA's unique AID (1 .. 2007) or 0 if not yet assigned */
	u32 flags;
	u16 capability;
	u16 listen_interval;
	u8 supported_rates[8];

	unsigned long last_auth;
	unsigned long last_assoc;
	unsigned long last_rxtx;
	unsigned long rx_packets, tx_packets;
	unsigned long rx_bytes, tx_bytes;
	struct sta_buffer_frame *tx_buf_head, *tx_buf_tail;
	int buffer_count; /* number of buffered frames */
	/* FIX: timeout buffers with an expiry time somehow derived from
	 * listen_interval */

	u8 last_rx_silence;
	u8 last_rx_signal;
	u8 last_rx_rate;
	u8 last_rx_flow;
	u8 last_rx_updated; /* IWSPY's struct iw_quality::updated */

	u8 tx_supp_rates; /* bit field of supported TX rates */
	u8 tx_rate; /* current TX rate (in 0.1 Mbps) */
	u8 tx_rate_idx; /* current TX rate (WLAN_RATE_*) */
	u8 tx_max_rate; /* max TX rate (WLAN_RATE_*) */
	u32 tx_count[WLAN_RATE_COUNT]; /* number of frames sent (per rate) */
	u32 rx_count[WLAN_RATE_COUNT]; /* number of frames received (per rate)
					*/
	u32 tx_since_last_failure;
};


#define MAX_STA_COUNT 1024

/* Maximum number of AIDs to use for STAs; must be 2007 or lower
 * (8802.11 limitation) */
#define MAX_AID_TABLE_SIZE 128

#define STA_HASH_SIZE 256
#define STA_HASH(sta) (sta[5])

/* FIX: what is best interval for timeout checks? */
#define AP_CHECK_INTERVAL (5 * HZ)

/* FIX: use small inactivity timeout for testing, but this should be changed
 * to something reasonable (specified in 8802.11??) for production version;
 * maybe add separate timeout for auth, but not assoc STAs */
#define AP_MAX_INACTIVITY (30 * 60 * HZ)

#define AP_QUEUE_LEN 10
enum { AP_QUEUED_RXDESC, AP_QUEUED_SKB };

struct ap_data {
	spinlock_t ap_queue_lock;
	void *ap_queued_items[AP_QUEUE_LEN];
	int ap_queued_type[AP_QUEUE_LEN];
	struct tq_struct ap_queue;
	int bridge_packets; /* send packet to associated STAs directly to the
			     * wireless media instead of higher layers in the
			     * kernel */
	unsigned int bridged_unicast; /* number of unicast frames bridged on
				       * wireless media */
	unsigned int bridged_multicast; /* number of non-unicast frames
					 * bridged on wireless media */

	spinlock_t sta_table_lock;
	int num_sta; /* number of entries in sta_list */
	struct list_head sta_list; /* STA info list head */
	struct sta_info *sta_hash[STA_HASH_SIZE];

	/* pointers to STA info; based on allocated AID or NULL if AID free
	 * AID is in the range 1-2007, so sta_aid[0] corresponders to AID 1
	 * and so on
	 */
	struct sta_info *sta_aid[MAX_AID_TABLE_SIZE];
	struct timer_list timer;
	struct proc_dir_entry *proc;
};


void hostap_rx(struct net_device *dev, struct hfa384x_rx_frame *rxdesc,
	       int force);
void hostap_queue_skb(struct net_device *dev, struct sk_buff *skb);
void ap_init_data(local_info_t *local);
void ap_free_data(struct ap_data *ap);
struct sta_info* ap_get_sta(struct ap_data *ap, u8 *sta);
void handle_ap_queue(void *data);
void schedule_packet_send(local_info_t *local, struct sta_info *sta);

#endif /* PRISM2_AP_H */
