#ifndef PRISM2_WLAN_H
#define PRISM2_WLAN_H


#define BIT(x) (1 << (x))

/* netlink groups */
#define PRISM2_MONITOR_GROUP BIT(0)

#ifndef ARPHRD_IEEE80211
#define ARPHRD_IEEE80211 801
#endif

struct hfa384x_rx_frame {
	/* HFA384X RX frame descriptor */
	u16 status __attribute__ ((packed));
	u32 time __attribute__ ((packed));
	u8 silence __attribute__ ((packed));
	u8 signal __attribute__ ((packed));
	u8 rate __attribute__ ((packed));
	u8 rxflow __attribute__ ((packed));
	u32 reserved __attribute__ ((packed));

	/* 802.11 */
	u16 frame_control __attribute__ ((packed));
	u16 duration_id __attribute__ ((packed));
	u8 addr1[6] __attribute__ ((packed));
	u8 addr2[6] __attribute__ ((packed));
	u8 addr3[6] __attribute__ ((packed));
	u16 seq_ctrl __attribute__ ((packed));
	u8 addr4[6] __attribute__ ((packed));
	u16 data_len __attribute__ ((packed));

	/* 802.3 */
	u8 dst_addr[6] __attribute__ ((packed));
	u8 src_addr[6] __attribute__ ((packed));
	u16 len __attribute__ ((packed));

	/* followed by frame data */
};


struct hfa384x_tx_frame {
	/* HFA384X TX frame descriptor */
	u16 status __attribute__ ((packed));
	u16 reserved1 __attribute__ ((packed));
	u16 reserved2 __attribute__ ((packed));
	u32 sw_support __attribute__ ((packed));
	u8 retry_count __attribute__ ((packed));
	u8 tx_rate __attribute__ ((packed));
	u16 tx_control __attribute__ ((packed));

	/* 802.11 */
	u16 frame_control __attribute__ ((packed)); /* parts not used */
	u16 duration_id __attribute__ ((packed));
	u8 addr1[6] __attribute__ ((packed));
	u8 addr2[6] __attribute__ ((packed)); /* not used */
	u8 addr3[6] __attribute__ ((packed));
	u16 seq_ctrl __attribute__ ((packed)); /* not used */
	u8 addr4[6] __attribute__ ((packed));
	u16 data_len __attribute__ ((packed));

	/* 802.3 */
	u8 dst_addr[6] __attribute__ ((packed));
	u8 src_addr[6] __attribute__ ((packed));
	u16 len __attribute__ ((packed));

	/* followed by frame data */
};


struct hfa384x_rid_hdr
{
	u16 len __attribute__ ((packed));
	u16 rid __attribute__ ((packed));
};


struct hfa384x_comp_ident
{
	u16 id __attribute__ ((packed));
	u16 variant __attribute__ ((packed));
	u16 major __attribute__ ((packed));
	u16 minor __attribute__ ((packed));
};

struct hfa384x_sup_range
{
	u16 role __attribute__ ((packed));
	u16 id __attribute__ ((packed));
	u16 variant __attribute__ ((packed));
	u16 bottom __attribute__ ((packed));
	u16 top __attribute__ ((packed));
};

struct hfa384x_build_id
{
	u16 pri_seq __attribute__ ((packed));
	u16 sec_seq __attribute__ ((packed));
};

#define HFA384X_SCAN_TXRATE_1 1
#define HFA384X_SCAN_TXRATE_2 2
#define HFA384X_SCAN_TXRATE_5_5 4
#define HFA384X_SCAN_TXRATE_11 8

struct hfa384x_scan_request {
	u16 channel_list __attribute__ ((packed));
	u16 txrate __attribute__ ((packed));
};

struct hfa384x_info_frame {
	u16 len __attribute__ ((packed));
	u16 type __attribute__ ((packed));
};

struct hfa384x_comm_tallies {
	u16 tx_unicast_frames __attribute__ ((packed));
	u16 tx_multicast_frames __attribute__ ((packed));
	u16 tx_fragments __attribute__ ((packed));
	u16 tx_unicast_octets __attribute__ ((packed));
	u16 tx_multicast_octets __attribute__ ((packed));
	u16 tx_deferred_transmissions __attribute__ ((packed));
	u16 tx_single_retry_frames __attribute__ ((packed));
	u16 tx_multiple_retry_frames __attribute__ ((packed));
	u16 tx_retry_limit_exceeded __attribute__ ((packed));
	u16 tx_discards __attribute__ ((packed));
	u16 rx_unicast_frames __attribute__ ((packed));
	u16 rx_multicast_frames __attribute__ ((packed));
	u16 rx_fragments __attribute__ ((packed));
	u16 rx_unicast_octets __attribute__ ((packed));
	u16 rx_multicast_octets __attribute__ ((packed));
	u16 rx_fcs_errors __attribute__ ((packed));
	u16 rx_discards_no_buffer __attribute__ ((packed));
	u16 tx_discards_wrong_sa __attribute__ ((packed));
	u16 rx_discards_wep_undecryptable __attribute__ ((packed));
	u16 rx_message_in_msg_fragments __attribute__ ((packed));
	u16 rx_message_in_bad_msg_fragments __attribute__ ((packed));
};

struct hfa384x_scan_result {
	u16 chid __attribute__ ((packed));
	u16 anl __attribute__ ((packed));
	u16 sl __attribute__ ((packed));
	u8 bssid[6] __attribute__ ((packed));
	u16 beacon_interval __attribute__ ((packed));
	u16 capability __attribute__ ((packed));
	u8 ssid[34] __attribute__ ((packed));
	u8 sup_rates[10] __attribute__ ((packed));
	u16 rate __attribute__ ((packed));
};

struct comm_tallies_sums {
	unsigned int tx_unicast_frames;
	unsigned int tx_multicast_frames;
	unsigned int tx_fragments;
	unsigned int tx_unicast_octets;
	unsigned int tx_multicast_octets;
	unsigned int tx_deferred_transmissions;
	unsigned int tx_single_retry_frames;
	unsigned int tx_multiple_retry_frames;
	unsigned int tx_retry_limit_exceeded;
	unsigned int tx_discards;
	unsigned int rx_unicast_frames;
	unsigned int rx_multicast_frames;
	unsigned int rx_fragments;
	unsigned int rx_unicast_octets;
	unsigned int rx_multicast_octets;
	unsigned int rx_fcs_errors;
	unsigned int rx_discards_no_buffer;
	unsigned int tx_discards_wrong_sa;
	unsigned int rx_discards_wep_undecryptable;
	unsigned int rx_message_in_msg_fragments;
	unsigned int rx_message_in_bad_msg_fragments;
};

/* I/O ports for HFA384X Controller access */
#define HFA384X_CMD_OFF 0x00
#define HFA384X_PARAM0_OFF 0x02
#define HFA384X_PARAM1_OFF 0x04
#define HFA384X_PARAM2_OFF 0x06
#define HFA384X_STATUS_OFF 0x08
#define HFA384X_RESP0_OFF 0x0A
#define HFA384X_RESP1_OFF 0x0C
#define HFA384X_RESP2_OFF 0x0E
#define HFA384X_INFOFID_OFF 0x10
#define HFA384X_CONTROL_OFF 0x14
#define HFA384X_SELECT0_OFF 0x18
#define HFA384X_SELECT1_OFF 0x1A
#define HFA384X_OFFSET0_OFF 0x1C
#define HFA384X_OFFSET1_OFF 0x1E
#define HFA384X_RXFID_OFF 0x20
#define HFA384X_ALLOCFID_OFF 0x22
#define HFA384X_TXCOMPLFID_OFF 0x24
#define HFA384X_SWSUPPORT0_OFF 0x28
#define HFA384X_SWSUPPORT1_OFF 0x2A
#define HFA384X_SWSUPPORT2_OFF 0x2C
#define HFA384X_EVSTAT_OFF 0x30
#define HFA384X_INTEN_OFF 0x32
#define HFA384X_EVACK_OFF 0x34
#define HFA384X_DATA0_OFF 0x36
#define HFA384X_DATA1_OFF 0x38
#define HFA384X_AUXPAGE_OFF 0x3A
#define HFA384X_AUXOFFSET_OFF 0x3C
#define HFA384X_AUXDATA_OFF 0x3E

/* Command codes for CMD reg. */
#define HFA384X_CMDCODE_INIT 0x00
#define HFA384X_CMDCODE_ENABLE 0x01
#define HFA384X_CMDCODE_DISABLE 0x02
#define HFA384X_CMDCODE_ALLOC 0x0A
#define HFA384X_CMDCODE_TRANSMIT 0x0B
#define HFA384X_CMDCODE_INQUIRE 0x11
#define HFA384X_CMDCODE_ACCESS 0x21
#define HFA384X_CMDCODE_ACCESS_WRITE (0x21 | BIT(8))
#define HFA384X_CMDCODE_READMIF 0x30
#define HFA384X_CMDCODE_WRITEMIF 0x31
#define HFA384X_CMDCODE_TEST 0x38

/* Test mode operations */
#define HFA384X_TEST_MONITOR 0x0B
#define HFA384X_TEST_STOP 0x0F

#define HFA384X_CMD_BUSY BIT(15)

#define HFA384X_CMD_TX_RECLAIM BIT(8)

#define HFA384X_OFFSET_ERR BIT(14)
#define HFA384X_OFFSET_BUSY BIT(15)


/* Events; EvStat, Interrupt mask (IntEn), and acknowledge bits (EvAck) */
#define HFA384X_EV_TICK BIT(15)
#define HFA384X_EV_WTERR BIT(14)
#define HFA384X_EV_INFDROP BIT(13)
#define HFA384X_EV_INFO BIT(7)
#define HFA384X_EV_DTIM BIT(5)
#define HFA384X_EV_CMD BIT(4)
#define HFA384X_EV_ALLOC BIT(3)
#define HFA384X_EV_TXEXC BIT(2)
#define HFA384X_EV_TX BIT(1)
#define HFA384X_EV_RX BIT(0)


/* HFA384X Configuration RIDs */
#define HFA384X_RID_CNFPORTTYPE 0xFC00
#define HFA384X_RID_CNFOWNMACADDR 0xFC01
#define HFA384X_RID_CNFDESIREDSSID 0xFC02
#define HFA384X_RID_CNFOWNCHANNEL 0xFC03
#define HFA384X_RID_CNFOWNSSID 0xFC04
#define HFA384X_RID_CNFOWNATIMWINDOW 0xFC05
#define HFA384X_RID_CNFSYSTEMSCALE 0xFC06
#define HFA384X_RID_CNFMAXDATALEN 0xFC07
#define HFA384X_RID_CNFWDSADDRESS 0xFC08
#define HFA384X_RID_CNFPMENABLED 0xFC09
#define HFA384X_RID_CNFPMEPS 0xFC0A
#define HFA384X_RID_CNFMULTICASTRECEIVE 0xFC0B
#define HFA384X_RID_CNFMAXSLEEPDURATION 0xFC0C
#define HFA384X_RID_CNFPMHOLDOVERDURATION 0xFC0D
#define HFA384X_RID_CNFOWNNAME 0xFC0E
#define HFA384X_RID_CNFOWNDTIMPERIOD 0xFC10
#define HFA384X_RID_CNFWDSADDRESS1 0xFC11
#define HFA384X_RID_CNFWDSADDRESS2 0xFC12
#define HFA384X_RID_CNFWDSADDRESS3 0xFC13
#define HFA384X_RID_CNFWDSADDRESS4 0xFC14
#define HFA384X_RID_CNFWDSADDRESS5 0xFC15
#define HFA384X_RID_CNFWDSADDRESS6 0xFC16
#define HFA384X_RID_CNFMULTICASTPMBUFFERING 0xFC17
#define HFA384X_RID_CNFWEPDEFAULTKEYID 0xFC23
#define HFA384X_RID_CNFDEFAULTKEY0 0xFC24
#define HFA384X_RID_CNFDEFAULTKEY1 0xFC25
#define HFA384X_RID_CNFDEFAULTKEY2 0xFC26
#define HFA384X_RID_CNFDEFAULTKEY3 0xFC27
#define HFA384X_RID_CNFWEPFLAGS 0xFC28
#define HFA384X_RID_CNFWEPKEYMAPPINGTABLE 0xFC29
#define HFA384X_RID_CNFAUTHENTICATION 0xFC2A
#define HFA384X_RID_CNFMAXASSOCSTA 0xFC2B
#define HFA384X_RID_CNFTXCONTROL 0xFC2C
#define HFA384X_RID_CNFROAMINGMODE 0xFC2D
#define HFA384X_RID_CNFHOSTAUTHENTICATION 0xFC2E
#define HFA384X_RID_CNFRCVCRCERROR 0xFC30
#define HFA384X_RID_CNFMMLIFE 0xFC31
#define HFA384X_RID_CNFALTRETRYCOUNT 0xFC32
#define HFA384X_RID_CNFBEACONINT 0xFC33
#define HFA384X_RID_CNFAPPCFINFO 0xFC34
#define HFA384X_RID_CNFSTAPCFINFO 0xFC35
#define HFA384X_RID_CNFPRIORITYQUSAGE 0xFC37
#define HFA384X_RID_CNFTIMCTRL 0xFC40
#define HFA384X_RID_CNFTHIRTY2TALLY 0xFC42
#define HFA384X_RID_CNFENHSECURITY 0xFC43
#define HFA384X_RID_GROUPADDRESSES 0xFC80
#define HFA384X_RID_CREATEIBSS 0xFC81
#define HFA384X_RID_FRAGMENTATIONTHRESHOLD 0xFC82
#define HFA384X_RID_RTSTHRESHOLD 0xFC83
#define HFA384X_RID_TXRATECONTROL 0xFC84
#define HFA384X_RID_PROMISCUOUSMODE 0xFC85
#define HFA384X_RID_FRAGMENTATIONTHRESHOLD0 0xFC90
#define HFA384X_RID_FRAGMENTATIONTHRESHOLD1 0xFC91
#define HFA384X_RID_FRAGMENTATIONTHRESHOLD2 0xFC92
#define HFA384X_RID_FRAGMENTATIONTHRESHOLD3 0xFC93
#define HFA384X_RID_FRAGMENTATIONTHRESHOLD4 0xFC94
#define HFA384X_RID_FRAGMENTATIONTHRESHOLD5 0xFC95
#define HFA384X_RID_FRAGMENTATIONTHRESHOLD6 0xFC96
#define HFA384X_RID_RTSTHRESHOLD0 0xFC97
#define HFA384X_RID_RTSTHRESHOLD1 0xFC98
#define HFA384X_RID_RTSTHRESHOLD2 0xFC99
#define HFA384X_RID_RTSTHRESHOLD3 0xFC9A
#define HFA384X_RID_RTSTHRESHOLD4 0xFC9B
#define HFA384X_RID_RTSTHRESHOLD5 0xFC9C
#define HFA384X_RID_RTSTHRESHOLD6 0xFC9D
#define HFA384X_RID_CNFSHORTPREAMBLE 0xFCB0
#define HFA384X_RID_CNFEXCLUDELONGPREAMBLE 0xFCB1
#define HFA384X_RID_CNFAUTHENTICATIONRSPTO 0xFCB2
#define HFA384X_RID_CNFBASICRATES 0xFCB3
#define HFA384X_RID_CNFSUPPORTEDRATES 0xFCB4
#define HFA384X_RID_TICKTIME 0xFCE0
#define HFA384X_RID_SCANREQUEST 0xFCE1
#define HFA384X_RID_JOINREQUEST 0xFCE2
#define HFA384X_RID_AUTHENTICATESTATION 0xFCE3
#define HFA384X_RID_CHANNELINFOREQUEST 0xFCE4

/* HFA384X Information RIDs */
#define HFA384X_RID_MAXLOADTIME 0xFD00
#define HFA384X_RID_DOWNLOADBUFFER 0xFD01
#define HFA384X_RID_PRIID 0xFD02
#define HFA384X_RID_PRISUPRANGE 0xFD03
#define HFA384X_RID_CFIACTRANGES 0xFD04
#define HFA384X_RID_NICSERNUM 0xFD0A
#define HFA384X_RID_NICID 0xFD0B
#define HFA384X_RID_MFISUPRANGE 0xFD0C
#define HFA384X_RID_CFISUPRANGE 0xFD0D
#define HFA384X_RID_CHANNELLIST 0xFD10
#define HFA384X_RID_REGULATORYDOMAINS 0xFD11
#define HFA384X_RID_TEMPTYPE 0xFD12
#define HFA384X_RID_CIS 0xFD13
#define HFA384X_RID_STAID 0xFD20
#define HFA384X_RID_STASUPRANGE 0xFD21
#define HFA384X_RID_MFIACTRANGES 0xFD22
#define HFA384X_RID_CFIACTRANGES2 0xFD23
#define HFA384X_RID_PORTSTATUS 0xFD40
#define HFA384X_RID_CURRENTSSID 0xFD41
#define HFA384X_RID_CURRENTBSSID 0xFD42
#define HFA384X_RID_COMMSQUALITY 0xFD43
#define HFA384X_RID_CURRENTTXRATE 0xFD44
#define HFA384X_RID_CURRENTBEACONINTERVAL 0xFD45
#define HFA384X_RID_CURRENTSCALETHRESHOLDS 0xFD46
#define HFA384X_RID_PROTOCOLRSPTIME 0xFD47
#define HFA384X_RID_SHORTRETRYLIMIT 0xFD48
#define HFA384X_RID_LONGRETRYLIMIT 0xFD49
#define HFA384X_RID_MAXTRANSMITLIFETIME 0xFD4A
#define HFA384X_RID_MAXRECEIVELIFETIME 0xFD4B
#define HFA384X_RID_CFPOLLABLE 0xFD4C
#define HFA384X_RID_AUTHENTICATIONALGORITHMS 0xFD4D
#define HFA384X_RID_PRIVACYOPTIONIMPLEMENTED 0xFD4F
#define HFA384X_RID_CURRENTTXRATE1 0xFD80
#define HFA384X_RID_CURRENTTXRATE2 0xFD81
#define HFA384X_RID_CURRENTTXRATE3 0xFD82
#define HFA384X_RID_CURRENTTXRATE4 0xFD83
#define HFA384X_RID_CURRENTTXRATE5 0xFD84
#define HFA384X_RID_CURRENTTXRATE6 0xFD85
#define HFA384X_RID_OWNMACADDR 0xFD86
#define HFA384X_RID_SCANRESULTSTABLE 0xFD88
#define HFA384X_RID_PHYTYPE 0xFDC0
#define HFA384X_RID_CURRENTCHANNEL 0xFDC1
#define HFA384X_RID_CURRENTPOWERSTATE 0xFDC2
#define HFA384X_RID_CCAMODE 0xFDC3
#define HFA384X_RID_SUPPORTEDDATARATES 0xFDC6
#define HFA384X_RID_BUILDSEQ 0xFFFE
#define HFA384X_RID_FWID 0xFFFF

/* HFA384X Information frames */
#define HFA384X_INFO_COMMTALLIES 0xF100
#define HFA384X_INFO_SCANRESULTS 0xF101
#define HFA384X_INFO_LINKSTATUS 0xF200

enum { HFA384X_LINKSTATUS_CONNECTED = 1,
       HFA384X_LINKSTATUS_DISCONNECTED = 2,
       HFA384X_LINKSTATUS_AP_CHANGE = 3,
       HFA384X_LINKSTATUS_AP_OUT_OF_RANGE = 4,
       HFA384X_LINKSTATUS_AP_IN_RANGE = 5,
       HFA384X_LINKSTATUS_ASSOC_FAILED = 6 };

enum { HFA384X_PORTTYPE_BSS = 1, HFA384X_PORTTYPE_WDS = 2,
       HFA384X_PORTTYPE_PSEUDO_IBSS = 3, HFA384X_PORTTYPE_IBSS = 0,
       HFA384X_PORTTYPE_HOSTAP = 6 };

#define HFA384X_RATES_1MBPS BIT(0)
#define HFA384X_RATES_2MBPS BIT(1)
#define HFA384X_RATES_5MBPS BIT(2)
#define HFA384X_RATES_11MBPS BIT(3)

#define HFA384X_WEPFLAGS_PRIVACYINVOKED BIT(0)
#define HFA384X_WEPFLAGS_EXCLUDEUNENCRYPTED BIT(1)
#define HFA384X_WEPFLAGS_HOSTENCRYPT BIT(4)
#define HFA384X_WEPFLAGS_HOSTDECRYPT BIT(7)

enum { HFA384X_RX_MSGTYPE_NORMAL = 0, HFA384X_RX_MSGTYPE_RFC1042 = 1,
       HFA384X_RX_MSGTYPE_BRIDGETUNNEL = 2, HFA384X_RX_MSGTYPE_MGMT = 4 };


#define HFA384X_TX_CTRL_ALT_RTRY BIT(5)
#define HFA384X_TX_CTRL_802_11 BIT(3)
#define HFA384X_TX_CTRL_802_3 0
#define HFA384X_TX_CTRL_TX_EX BIT(2)
#define HFA384X_TX_CTRL_TX_OK BIT(1)

#define HFA384X_TX_STATUS_RETRYERR BIT(0)
#define HFA384X_TX_STATUS_AGEDERR BIT(1)
#define HFA384X_TX_STATUS_DISCON BIT(2)
#define HFA384X_TX_STATUS_FORMERR BIT(3)

/* IEEE 802.11 defines */

#define WLAN_FC_PVER (BIT(1) | BIT(0))
#define WLAN_FC_TODS BIT(8)
#define WLAN_FC_FROMDS BIT(9)
#define WLAN_FC_MOREFRAG BIT(10)
#define WLAN_FC_RETRY BIT(11)
#define WLAN_FC_PWRMGT BIT(12)
#define WLAN_FC_MOREDATA BIT(13)
#define WLAN_FC_ISWEP BIT(14)
#define WLAN_FC_ORDER BIT(15)

#define WLAN_FC_GET_TYPE(fc) (((fc) & (BIT(3) | BIT(2))) >> 2)
#define WLAN_FC_GET_STYPE(fc) \
	(((fc) & (BIT(7) | BIT(6) | BIT(5) | BIT(4))) >> 4)

#define WLAN_GET_SEQ_FRAG(seq) ((seq) & (BIT(3) | BIT(2) | BIT(1) | BIT(0)))
#define WLAN_GET_SEQ_SEQ(seq) \
	(((seq) & (~(BIT(3) | BIT(2) | BIT(1) | BIT(0)))) >> 4)

#define WLAN_FC_TYPE_MGMT 0
#define WLAN_FC_TYPE_CTRL 1
#define WLAN_FC_TYPE_DATA 2

/* management */
#define WLAN_FC_STYPE_ASSOC_REQ 0
#define WLAN_FC_STYPE_ASSOC_RESP 1
#define WLAN_FC_STYPE_REASSOC_REQ 2
#define WLAN_FC_STYPE_REASSOC_RESP 3
#define WLAN_FC_STYPE_PROBE_REQ 4
#define WLAN_FC_STYPE_PROBE_RESP 5
#define WLAN_FC_STYPE_BEACON 8
#define WLAN_FC_STYPE_ATIM 9
#define WLAN_FC_STYPE_DISASSOC 10
#define WLAN_FC_STYPE_AUTH 11
#define WLAN_FC_STYPE_DEAUTH 12

/* control */
#define WLAN_FC_STYPE_PSPOLL 10
#define WLAN_FC_STYPE_RTS 11
#define WLAN_FC_STYPE_CTS 12
#define WLAN_FC_STYPE_ACK 13
#define WLAN_FC_STYPE_CFEND 14
#define WLAN_FC_STYPE_CFENDACK 15

/* data */
#define WLAN_FC_STYPE_DATA 0
#define WLAN_FC_STYPE_DATA_CFACK 1
#define WLAN_FC_STYPE_DATA_CFPOLL 2
#define WLAN_FC_STYPE_DATA_CFACKPOLL 3
#define WLAN_FC_STYPE_NULLFUNC 4
#define WLAN_FC_STYPE_CFACK 5
#define WLAN_FC_STYPE_CFPOLL 6
#define WLAN_FC_STYPE_CFACKPOLL 7

/* Authentication algorithms */
#define WLAN_AUTH_OPEN 0
#define WLAN_AUTH_SHARED_KEY 1

#define WLAN_CAPABILITY_ESS BIT(0)
#define WLAN_CAPABILITY_IBSS BIT(1)
#define WLAN_CAPABILITY_CF_POLLABLE BIT(2)
#define WLAN_CAPABILITY_CF_POLL_REQUEST BIT(3)
#define WLAN_CAPABILITY_PRIVACY BIT(4)

/* Status codes */
#define WLAN_STATUS_SUCCESS 0
#define WLAN_STATUS_UNSPECIFIED_FAILURE 1
#define WLAN_STATUS_CAPS_UNSUPPORTED 10
#define WLAN_STATUS_REASSOC_NO_ASSOC 11
#define WLAN_STATUS_ASSOC_DENIED_UNSPEC 12
#define WLAN_STATUS_NOT_SUPPORTED_AUTH_ALG 13
#define WLAN_STATUS_UNKNOWN_AUTH_TRANSACTION 14
#define WLAN_STATUS_CHALLENGE_FAIL 15
#define WLAN_STATUS_AUTH_TIMEOUT 16
#define WLAN_STATUS_AP_UNABLE_TO_HANDLE_NEW_STA 17
#define WLAN_STATUS_ASSOC_DENIED_RATES 18
/* 802.11b */
#define WLAN_STATUS_ASSOC_DENIED_NOSHORT 19
#define WLAN_STATUS_ASSOC_DENIED_NOPBCC 20
#define WLAN_STATUS_ASSOC_DENIED_NOAGILITY 21

/* Reason codes */
#define WLAN_REASON_UNSPECIFIED 1
#define WLAN_REASON_PREV_AUTH_NOT_VALID 2
#define WLAN_REASON_DEAUTH_LEAVING 3
#define WLAN_REASON_DISASSOC_DUE_TO_INACTIVITY 4
#define WLAN_REASON_DISASSOC_AP_BUSY 5
#define WLAN_REASON_CLASS2_FRAME_FROM_NONAUTH_STA 6
#define WLAN_REASON_CLASS3_FRAME_FROM_NONASSOC_STA 7
#define WLAN_REASON_DISASSOC_STA_HAS_LEFT 8
#define WLAN_REASON_STA_REQ_ASSOC_WITHOUT_AUTH 9


/* Information Element IDs */
#define WLAN_EID_SSID 0
#define WLAN_EID_SUPP_RATES 1
#define WLAN_EID_FH_PARAMS 2
#define WLAN_EID_DS_PARAMS 3
#define WLAN_EID_CF_PARAMS 4
#define WLAN_EID_TIM 5
#define WLAN_EID_IBSS_PARAMS 6
#define WLAN_EID_CHALLENGE 16


#define MAC2STR(a) (a)[0], (a)[1], (a)[2], (a)[3], (a)[4], (a)[5]
#define MACSTR "%02x:%02x:%02x:%02x:%02x:%02x"

#ifdef __KERNEL__

#define PRISM2_TXFID_COUNT 16
#define PRISM2_DATA_MAXLEN 2304
#define PRISM2_TXFID_LEN (PRISM2_DATA_MAXLEN + sizeof(struct hfa384x_tx_frame))
#define PRISM2_TXFID_EMPTY 0xffff
#define PRISM2_TXFID_RESERVED 0xfffe
#define MAX_SSID_LEN 32
#define MAX_NAME_LEN 32

#define PRISM2_DUMP_RX_HDR 1
#define PRISM2_DUMP_TX_HDR 2

typedef struct local_info {
	dev_node_t node;
	struct net_device *dev;
	dev_link_t *link;
	spinlock_t cmdlock, baplock;
	u16 infofid; /* MAC buffer id for info frame */
	/* txfid, intransmitfid, next_txtid, and next_alloc are protected by
	 * txfidlock */
	spinlock_t txfidlock;
	u16 txfid[PRISM2_TXFID_COUNT]; /* buffer IDs for TX frames */
	/* buffer IDs for intransmit frames or PRISM2_TXFID_EMPTY if
	 * corresponding txfid is free for next TX frame */
	u16 intransmitfid[PRISM2_TXFID_COUNT];
	int next_txfid; /* index to the next txfid to be checked for
			 * availability */
	int next_alloc; /* index to the next intransmitfid to be checked for
			 * allocation events */
	struct ap_data *ap;
	int manfid; /* from CISTPL_MANFID */
	int prodid; /* from CISTPL_MANFID */
	int is_symbol; /* Symbol-based card */
	int is_lucent; /* Lucent-based card */

	char essid[MAX_SSID_LEN + 1];
	struct comm_tallies_sums comm_tallies;
	struct net_device_stats stats;
	struct proc_dir_entry *proc;
	int iw_mode; /* operating mode (IW_MODE_*) */
	int pseudo_adhoc; /* 0: IW_MODE_ADHOC is real 802.11 compliant IBSS
			   * 1: IW_MODE_ADHOC is "pseudo IBSS" */
	char bssid[ETH_ALEN];
	int frame_dump; /* dump RX/TX frame headers, PRISM2_DUMP_ flags */
	int fw_tx_rate_control;
	int hw_resetting;
	int hw_ready;
	int hw_reset_tries; /* how many times reset has been tried */

	/* skb queue for packets to be send using dev_queue_xmit() after
	 * exiting hard IRQ handler (prism2_rx) */
	struct sk_buff_head bridge_list;
	struct tq_struct bridge_queue;

#ifdef WIRELESS_EXT
	struct iw_statistics wstats;
#endif
#ifdef PRISM2_MONITOR
	struct sock *nl_monitor;
	enum {
		PRISM2_MONITOR_OFF, PRISM2_MONITOR_NL, PRISM2_MONITOR_DEV
	} monitor_type;
#endif
} local_info_t;

/* if wireless ext is not supported */
#ifndef IW_MODE_ADHOC
#define IW_MODE_ADHOC 1
#endif
#ifndef IW_MODE_INFRA
#define IW_MODE_INFRA 2
#endif
#ifndef IW_MODE_MASTER
#define IW_MODE_MASTER 3
#endif

#if 1

#define DEBUG_FID 1
#define DEBUG_PS 2
#define DEBUG_FLOW 4
#define DEBUG_AP 8
#define DEBUG_HW 16
#define DEBUG_EXTRA 32
#define DEBUG_EXTRA2 64
#define DEBUG_MASK (DEBUG_PS | DEBUG_FLOW | DEBUG_AP | DEBUG_HW | \
	DEBUG_EXTRA)
#define PDEBUG(n, args...) \
do { if ((n) & DEBUG_MASK) printk(KERN_DEBUG args); } while (0)
#define PDEBUG2(n, args...) \
do { if ((n) & DEBUG_MASK) printk(args); } while (0)

#else

#define PDEBUG(n, args...)
#define PDEBUG2(n, args...)

#endif

enum { BAP0 = 0, BAP1 = 1 };

int hfa384x_setup_bap(struct net_device *dev, u16 bap, u16 id, int offset);
int hfa384x_from_bap(struct net_device *dev, u16 bap, void *buf, int len);
int hfa384x_to_bap(struct net_device *dev, u16 bap, void *buf, int len);

int prism2_get_txfid_idx(local_info_t *local);
int prism2_transmit(struct net_device *dev, int idx);
int prism2_set_tim(struct net_device *dev, u16 aid, int set);
void prism2_dump_tx_header(const char *name,
			   const struct hfa384x_tx_frame *tx);

#endif /* __KERNEL__ */

#endif /* PRISM2_WLAN_H */
